/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book.element;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.screen.book.TextDataRenderer;
import slimeknights.mantle.client.screen.book.element.ImageElement;
import slimeknights.mantle.client.screen.book.element.SizedBookElement;

public class SelectionElement
extends SizedBookElement {
    public static final int IMG_SIZE = 32;
    public static final int WIDTH = 42;
    public static final int HEIGHT = 42;
    private SectionData section;
    private ImageElement iconRenderer;
    private final int iconX;
    private final int iconY;

    public SelectionElement(int x, int y, SectionData section) {
        super(x, y, 42, 42);
        this.section = section;
        this.iconX = this.x + 21 - 16;
        this.iconY = this.y + 21 - 16;
        this.iconRenderer = new ImageElement(this.iconX, this.iconY, 32, 32, section.icon);
    }

    @Override
    public void draw(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks, class_327 fontRenderer) {
        boolean unlocked = this.section.isUnlocked(this.parent.advancementCache);
        boolean hover = this.isHovered(mouseX, mouseY);
        if (hover) {
            guiGraphics.method_25294(this.iconX, this.iconY, this.iconX + 32, this.iconY + 32, this.parent.book.appearance.hoverColor);
        }
        if (unlocked) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(hover ? 1.0f : 0.5f));
        } else {
            float r = (float)(this.parent.book.appearance.lockedSectionColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(this.parent.book.appearance.lockedSectionColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(this.parent.book.appearance.lockedSectionColor & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)0.75f);
        }
        this.iconRenderer.draw(guiGraphics, mouseX, mouseY, partialTicks, fontRenderer);
        if (this.section.parent.appearance.drawSectionListText) {
            String title = this.section.getTitle().replace("\\n", "\n");
            Objects.requireNonNull(fontRenderer);
            String[] splitTitle = TextDataRenderer.cropStringBySize(title, "", 44, 9 * 2 + 1, fontRenderer, 1.0f);
            for (int i = 0; i < splitTitle.length; ++i) {
                int textW = fontRenderer.method_1727(splitTitle[i]);
                int textX = this.x + 21 - textW / 2;
                Objects.requireNonNull(fontRenderer);
                int n = this.y + 42 - 9 / 2;
                Objects.requireNonNull(fontRenderer);
                int textY = n + 9 * i;
                guiGraphics.method_51433(fontRenderer, splitTitle[i], textX, textY, hover ? -16777216 : 0x7F000000, false);
            }
        }
    }

    @Override
    public void drawOverlay(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks, class_327 fontRenderer) {
        if (this.section != null && this.isHovered(mouseX, mouseY)) {
            ArrayList<class_2561> text = new ArrayList<class_2561>();
            text.add((class_2561)class_2561.method_43470((String)this.section.getTitle()));
            if (!this.section.isUnlocked(this.parent.advancementCache)) {
                text.add((class_2561)class_2561.method_43470((String)"Locked").method_27692(class_124.field_1061));
                text.add((class_2561)class_2561.method_43470((String)"Requirements:"));
                for (String requirement : this.section.requirements) {
                    text.add((class_2561)class_2561.method_43470((String)requirement));
                }
            }
            this.drawTooltip(guiGraphics, text, mouseX, mouseY, fontRenderer);
        }
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.section != null && this.section.isUnlocked(this.parent.advancementCache) && this.isHovered(mouseX, mouseY)) {
            this.parent.openPage(this.parent.book.getFirstPageNumber(this.section, this.parent.advancementCache));
        }
    }
}

